/*
 * Decompiled with CFR 0.152.
 */
package Game_Engine.Engine.Objs;

import BryceMath.Calculations.Colors;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;

public class ImageB {
    private final BufferedImage image;
    private final BryceMath.Geometry.Rectangle bounds;

    public ImageB(BufferedImage image_in) {
        this.image = image_in;
        this.bounds = this.getBounds(this.image);
    }

    public ImageB(BufferedImage image_in, BryceMath.Geometry.Rectangle bounds_in) {
        this.image = image_in;
        BryceMath.Geometry.Rectangle full_bounds = this.getBounds(this.image);
        this.bounds = full_bounds.intersection(bounds_in);
    }

    public ImageB getSubImage(BryceMath.Geometry.Rectangle sub_bounds) {
        if ((sub_bounds = this.bounds.intersection(sub_bounds)).getW() < 1 || sub_bounds.getH() < 1) {
            return null;
        }
        return new ImageB(this.image, sub_bounds);
    }

    public BryceMath.Geometry.Rectangle getBounds() {
        return this.bounds.clone();
    }

    private BryceMath.Geometry.Rectangle getBounds(BufferedImage image) {
        return new BryceMath.Geometry.Rectangle(0, 0, image.getWidth(), image.getHeight());
    }

    public Graphics2D getGraphics() {
        Graphics2D g = (Graphics2D)this.image.getGraphics();
        g.setClip(new Rectangle(this.bounds.getX(), this.bounds.getY(), this.bounds.getW(), this.bounds.getH()));
        return g;
    }

    public int getRGB(int x, int y) {
        if (x < 0 || x >= this.image.getWidth() || y < 0 || y >= this.image.getHeight()) {
            return Colors.C_CLEAR.getRGB();
        }
        return this.image.getRGB(x, y);
    }

    public void setRGB(int x, int y, int c) {
        if (x < 0 || x >= this.image.getWidth() || y < 0 || y >= this.image.getHeight()) {
            throw new Error("Bad input coordinates!");
        }
        this.image.setRGB(x, y, c);
    }

    public Dimension getDimension() {
        return new Dimension(this.image.getWidth(), this.image.getHeight());
    }

    public int getW() {
        return this.image.getWidth();
    }

    public int getH() {
        return this.image.getHeight();
    }
}

